<?php

namespace Drupal\commerce_payu_webcheckout\Plugin\Commerce\PayuItem;

use Drupal\commerce_payment\Entity\PaymentInterface;
use Drupal\commerce_payu_webcheckout\Plugin\PayuItemBase;

/**
 * Appends the zipCode.
 *
 * If you need to change how this is calculated, I suggest
 * you use the hook hook_payu_item_plugin_alter().
 *
 * @see commerce_payu_webcheckout.api.php
 *
 * @PayuItem(
 *   id = "zipCode"
 * )
 */
class ZipCode extends PayuItemBase {

  /**
   * {@inheritdoc}
   */
  public function issueValue(PaymentInterface $payment) {
    $order = $payment->getOrder();
    $billing_profile = $order->getBillingProfile();
    if ($billing_profile instanceof \Drupal\profile\Entity\Profile) {
      $address = $billing_profile->get('address')->getValue();
      $address = reset($address);
      return isset($address['postal_code']) ? $address['postal_code'] : '';
    }
    else {
      return '';
    }
  }

}
